<?php
/**
 * The template to display Admin notices
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.64
 */

$integro_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$integro_skins_args = get_query_var( 'integro_skins_notice_args' );
?>
<div class="integro_admin_notice integro_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$integro_theme_img = integro_get_file_url( 'screenshot.jpg' );
	if ( '' != $integro_theme_img ) {
		?>
		<div class="integro_notice_image"><img src="<?php echo esc_url( $integro_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'integro' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="integro_notice_title">
		<?php esc_html_e( 'New skins are available', 'integro' ); ?>
	</h3>
	<?php

	// Description
	$integro_total      = $integro_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$integro_skins_msg  = $integro_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $integro_total, 'integro' ), $integro_total ) . '</strong>'
							: '';
	$integro_total      = $integro_skins_args['free'];
	$integro_skins_msg .= $integro_total > 0
							? ( ! empty( $integro_skins_msg ) ? ' ' . esc_html__( 'and', 'integro' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $integro_total, 'integro' ), $integro_total ) . '</strong>'
							: '';
	$integro_total      = $integro_skins_args['pay'];
	$integro_skins_msg .= $integro_skins_args['pay'] > 0
							? ( ! empty( $integro_skins_msg ) ? ' ' . esc_html__( 'and', 'integro' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $integro_total, 'integro' ), $integro_total ) . '</strong>'
							: '';
	?>
	<div class="integro_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'integro' ), $integro_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="integro_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $integro_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'integro' );
			?>
		</a>
	</div>
</div>
