<?php
/**
 * The template to display the widgets area in the header
 *
 * @package INTEGRO
 * @since INTEGRO 1.0
 */

// Header sidebar
$integro_header_name    = integro_get_theme_option( 'header_widgets' );
$integro_header_present = ! integro_is_off( $integro_header_name ) && is_active_sidebar( $integro_header_name );
if ( $integro_header_present ) {
	integro_storage_set( 'current_sidebar', 'header' );
	$integro_header_wide = integro_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $integro_header_name ) ) {
		dynamic_sidebar( $integro_header_name );
	}
	$integro_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $integro_widgets_output ) ) {
		$integro_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $integro_widgets_output );
		$integro_need_columns   = strpos( $integro_widgets_output, 'columns_wrap' ) === false;
		if ( $integro_need_columns ) {
			$integro_columns = max( 0, (int) integro_get_theme_option( 'header_columns' ) );
			if ( 0 == $integro_columns ) {
				$integro_columns = min( 6, max( 1, integro_tags_count( $integro_widgets_output, 'aside' ) ) );
			}
			if ( $integro_columns > 1 ) {
				$integro_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $integro_columns ) . ' widget', $integro_widgets_output );
			} else {
				$integro_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $integro_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'integro_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $integro_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $integro_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'integro_action_before_sidebar', 'header' );
				integro_show_layout( $integro_widgets_output );
				do_action( 'integro_action_after_sidebar', 'header' );
				if ( $integro_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $integro_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'integro_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
