<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.50
 */

$integro_template_args = get_query_var( 'integro_template_args' );
if ( is_array( $integro_template_args ) ) {
	$integro_columns    = empty( $integro_template_args['columns'] ) ? 2 : max( 1, $integro_template_args['columns'] );
	$integro_blog_style = array( $integro_template_args['type'], $integro_columns );
} else {
	$integro_template_args = array();
	$integro_blog_style = explode( '_', integro_get_theme_option( 'blog_style' ) );
	$integro_columns    = empty( $integro_blog_style[1] ) ? 2 : max( 1, $integro_blog_style[1] );
}
$integro_blog_id       = integro_get_custom_blog_id( join( '_', $integro_blog_style ) );
$integro_blog_style[0] = str_replace( 'blog-custom-', '', $integro_blog_style[0] );
$integro_expanded      = ! integro_sidebar_present() && integro_get_theme_option( 'expand_content' ) == 'expand';
$integro_components    = ! empty( $integro_template_args['meta_parts'] )
							? ( is_array( $integro_template_args['meta_parts'] )
								? join( ',', $integro_template_args['meta_parts'] )
								: $integro_template_args['meta_parts']
								)
							: integro_array_get_keys_by_value( integro_get_theme_option( 'meta_parts' ) );
$integro_post_format   = get_post_format();
$integro_post_format   = empty( $integro_post_format ) ? 'standard' : str_replace( 'post-format-', '', $integro_post_format );

$integro_blog_meta     = integro_get_custom_layout_meta( $integro_blog_id );
$integro_custom_style  = ! empty( $integro_blog_meta['scripts_required'] ) ? $integro_blog_meta['scripts_required'] : 'none';

if ( ! empty( $integro_template_args['slider'] ) || $integro_columns > 1 || ! integro_is_off( $integro_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $integro_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( integro_is_off( $integro_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $integro_custom_style ) ) . "-1_{$integro_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $integro_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $integro_columns )
					. ' post_layout_' . esc_attr( $integro_blog_style[0] )
					. ' post_layout_' . esc_attr( $integro_blog_style[0] ) . '_' . esc_attr( $integro_columns )
					. ( ! integro_is_off( $integro_custom_style )
						? ' post_layout_' . esc_attr( $integro_custom_style )
							. ' post_layout_' . esc_attr( $integro_custom_style ) . '_' . esc_attr( $integro_columns )
						: ''
						)
		);
	integro_add_blog_animation( $integro_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'integro_action_show_layout', $integro_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $integro_template_args['slider'] ) || $integro_columns > 1 || ! integro_is_off( $integro_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
