<?php
$integro_slider_sc = integro_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $integro_slider_sc ) && strpos( $integro_slider_sc, '[' ) !== false && strpos( $integro_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( integro_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$integro_anchor_icon = integro_get_theme_option( 'front_page_title_anchor_icon' );
		$integro_anchor_text = integro_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $integro_anchor_icon ) || ! empty( $integro_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $integro_anchor_icon ) ? ' icon="' . esc_attr( $integro_anchor_icon ) . '"' : '' )
									. ( ! empty( $integro_anchor_text ) ? ' title="' . esc_attr( $integro_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $integro_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$integro_scheme = integro_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $integro_scheme ) && ! integro_is_inherit( $integro_scheme ) ) {
			echo ' scheme_' . esc_attr( $integro_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( integro_get_theme_option( 'front_page_title_paddings' ) );
		if ( integro_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$integro_css      = '';
		$integro_bg_image = integro_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $integro_bg_image ) ) {
			$integro_css .= 'background-image: url(' . esc_url( integro_get_attachment_url( $integro_bg_image ) ) . ');';
		}
		if ( ! empty( $integro_css ) ) {
			echo ' style="' . esc_attr( $integro_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$integro_anchor_icon = integro_get_theme_option( 'front_page_title_anchor_icon' );
		$integro_anchor_text = integro_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $integro_anchor_icon ) || ! empty( $integro_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $integro_anchor_icon ) ? ' icon="' . esc_attr( $integro_anchor_icon ) . '"' : '' )
									. ( ! empty( $integro_anchor_text ) ? ' title="' . esc_attr( $integro_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( integro_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' integro-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$integro_css      = '';
			$integro_bg_mask  = integro_get_theme_option( 'front_page_title_bg_mask' );
			$integro_bg_color_type = integro_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $integro_bg_color_type ) {
				$integro_bg_color = integro_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $integro_bg_color_type ) {
				$integro_bg_color = integro_get_scheme_color( 'bg_color', $integro_scheme );
			} else {
				$integro_bg_color = '';
			}
			if ( ! empty( $integro_bg_color ) && $integro_bg_mask > 0 ) {
				$integro_css .= 'background-color: ' . esc_attr(
					1 == $integro_bg_mask ? $integro_bg_color : integro_hex2rgba( $integro_bg_color, $integro_bg_mask )
				) . ';';
			}
			if ( ! empty( $integro_css ) ) {
				echo ' style="' . esc_attr( $integro_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$integro_caption = integro_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $integro_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $integro_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $integro_caption, 'integro_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$integro_description = integro_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $integro_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $integro_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $integro_description ), 'integro_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( integro_get_theme_option( 'front_page_title_button1_link' ) != '' || integro_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						integro_show_layout( integro_customizer_partial_refresh_front_page_title_button1_link() );
						integro_show_layout( integro_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
