<div class="front_page_section front_page_section_about<?php
	$integro_scheme = integro_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $integro_scheme ) && ! integro_is_inherit( $integro_scheme ) ) {
		echo ' scheme_' . esc_attr( $integro_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( integro_get_theme_option( 'front_page_about_paddings' ) );
	if ( integro_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$integro_css      = '';
		$integro_bg_image = integro_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $integro_bg_image ) ) {
			$integro_css .= 'background-image: url(' . esc_url( integro_get_attachment_url( $integro_bg_image ) ) . ');';
		}
		if ( ! empty( $integro_css ) ) {
			echo ' style="' . esc_attr( $integro_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$integro_anchor_icon = integro_get_theme_option( 'front_page_about_anchor_icon' );
	$integro_anchor_text = integro_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $integro_anchor_icon ) || ! empty( $integro_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $integro_anchor_icon ) ? ' icon="' . esc_attr( $integro_anchor_icon ) . '"' : '' )
									. ( ! empty( $integro_anchor_text ) ? ' title="' . esc_attr( $integro_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( integro_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' integro-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$integro_css           = '';
			$integro_bg_mask       = integro_get_theme_option( 'front_page_about_bg_mask' );
			$integro_bg_color_type = integro_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $integro_bg_color_type ) {
				$integro_bg_color = integro_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $integro_bg_color_type ) {
				$integro_bg_color = integro_get_scheme_color( 'bg_color', $integro_scheme );
			} else {
				$integro_bg_color = '';
			}
			if ( ! empty( $integro_bg_color ) && $integro_bg_mask > 0 ) {
				$integro_css .= 'background-color: ' . esc_attr(
					1 == $integro_bg_mask ? $integro_bg_color : integro_hex2rgba( $integro_bg_color, $integro_bg_mask )
				) . ';';
			}
			if ( ! empty( $integro_css ) ) {
				echo ' style="' . esc_attr( $integro_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$integro_caption = integro_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $integro_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $integro_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $integro_caption, 'integro_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$integro_description = integro_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $integro_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $integro_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $integro_description ), 'integro_kses_content' ); ?></div>
				<?php
			}

			// Content
			$integro_content = integro_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $integro_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $integro_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$integro_page_content_mask = '%%CONTENT%%';
					if ( strpos( $integro_content, $integro_page_content_mask ) !== false ) {
						$integro_content = preg_replace(
							'/(\<p\>\s*)?' . $integro_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$integro_content
						);
					}
					integro_show_layout( $integro_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
