<?php
/**
 * The Front Page template file.
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.31
 */

get_header();

// If front-page is a static page
if ( get_option( 'show_on_front' ) == 'page' ) {

	// If Front Page Builder is enabled - display sections
	if ( integro_is_on( integro_get_theme_option( 'front_page_enabled', false ) ) ) {

		if ( have_posts() ) {
			the_post();
		}

		$integro_sections = integro_array_get_keys_by_value( integro_get_theme_option( 'front_page_sections' ) );
		if ( is_array( $integro_sections ) ) {
			foreach ( $integro_sections as $integro_section ) {
				get_template_part( apply_filters( 'integro_filter_get_template_part', 'front-page/section', $integro_section ), $integro_section );
			}
		}

		// Else if this page is a blog archive
	} elseif ( is_page_template( 'blog.php' ) ) {
		get_template_part( apply_filters( 'integro_filter_get_template_part', 'blog' ) );

		// Else - display a native page content
	} else {
		get_template_part( apply_filters( 'integro_filter_get_template_part', 'page' ) );
	}

	// Else get the template 'index.php' to show posts
} else {
	get_template_part( apply_filters( 'integro_filter_get_template_part', 'index' ) );
}

get_footer();
