<?php
/**
 * The template to display the site logo in the footer
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.10
 */

// Logo
if ( integro_is_on( integro_get_theme_option( 'logo_in_footer' ) ) ) {
	$integro_logo_image = integro_get_logo_image( 'footer' );
	$integro_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $integro_logo_image['logo'] ) || ! empty( $integro_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $integro_logo_image['logo'] ) ) {
					$integro_attr = integro_getimagesize( $integro_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $integro_logo_image['logo'] ) . '"'
								. ( ! empty( $integro_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $integro_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'integro' ) . '"'
								. ( ! empty( $integro_attr[3] ) ? ' ' . wp_kses_data( $integro_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $integro_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $integro_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
