<?php
/**
 * The template to display Admin notices
 *
 * @package INTEGRO
 * @since INTEGRO 1.0.1
 */

$integro_theme_slug = get_option( 'template' );
$integro_theme_obj  = wp_get_theme( $integro_theme_slug );
?>
<div class="integro_admin_notice integro_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$integro_theme_img = integro_get_file_url( 'screenshot.jpg' );
	if ( '' != $integro_theme_img ) {
		?>
		<div class="integro_notice_image"><img src="<?php echo esc_url( $integro_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'integro' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="integro_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'integro' ),
				$integro_theme_obj->get( 'Name' ) . ( INTEGRO_THEME_FREE ? ' ' . __( 'Free', 'integro' ) : '' ),
				$integro_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="integro_notice_text">
		<p class="integro_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $integro_theme_obj->description ) );
			?>
		</p>
		<p class="integro_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'integro' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="integro_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=integro_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'integro' );
			?>
		</a>
	</div>
</div>
