<?php
/**
 * Skin Setup
 *
 * @package INTEGRO
 * @since INTEGRO 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'integro_theme_defaults' ) ) {
	function integro_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'integro_skin_woocommerce_allow_extensions' ) ) {
	add_filter( 'integro_filter_load_woocommerce_extensions', 'integro_skin_woocommerce_allow_extensions' );
	function integro_skin_woocommerce_allow_extensions( $allow ) {
		return false;
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'integro_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'integro_skin_setup', 1 );
	function integro_skin_setup() {

		$GLOBALS['INTEGRO_STORAGE'] = array_merge( $GLOBALS['INTEGRO_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-ancora',

			'theme_doc_url'       => '//doc.themerex.net/integro/',

			'theme_demofiles_url' => '//demofiles.ancorathemes.com/integro/',
			
			'theme_rate_url'      => '//themeforest.net/downloads',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			'theme_video_url'     => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',   // Ancora

			'theme_privacy_url'   => '//ancorathemes.com/privacy-policy/',                   // Ancora

			'portfolio_url'       => '//themeforest.net/user/ancorathemes/portfolio',        // Ancora

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'integro_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'integro_skin_setup_settings', 1 );
	function integro_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		integro_storage_set_array( 'settings', 'thumbs_in_navigation', false );
		integro_storage_set_array2( 'required_plugins', 'woocommerce', 'install', true );
		integro_storage_set_array2( 'required_plugins', 'ti-woocommerce-wishlist', 'install', true );
		integro_storage_set_array2( 'required_plugins', 'elegro-payment', 'install', true );

	}
}

// add/remove Theme Options elements
if ( ! function_exists( 'integro_skin_options_theme_setup2' ) ) {
	add_action( 'after_setup_theme', 'integro_skin_options_theme_setup2', 4 );
	function integro_skin_options_theme_setup2() {
		integro_storage_set_array2( 'options', 'color_scheme', 'std', 'dark');
		integro_storage_set_array2( 'options', 'sidebar_scheme', 'std', 'dark');
		integro_storage_set_array2( 'options', 'footer_scheme', 'std', 'dark');
		integro_storage_set_array2( 'options', 'sidebar_position', 'std', 'hide');
	}
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'integro_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'integro_skin_setup_fonts', 1 );
	function integro_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		integro_storage_set(
			'load_fonts', array(
                array(
                    'name'   => 'Bebas Neue',
                    'family' => 'cursive',
                    'link'   => '',
                    'styles' => 'ital,wght@0,400;1,400',
                ),
                array(
                    'name'   => 'Roboto',
                    'family' => 'sans-serif',
                    'link'   => '',
                    'styles' => 'ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900',
                ),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		integro_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => integro_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'integro' );

		integro_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'integro' ) ),
					'font-family'     => 'Roboto,sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.7em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.8em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'integro' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '3.353em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.14em',
					'margin-bottom'   => '0.38em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '2.765em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0.75px',
					'margin-top'      => '0.84em',
					'margin-bottom'   => '0.4em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '2.059em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0.5px',
					'margin-top'      => '1.18em',
					'margin-bottom'   => '0.55em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '1.647em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0.55px',
					'margin-top'      => '1.45em',
					'margin-bottom'   => '0.58em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '1.412em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.208em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0.58px',
					'margin-top'      => '1.57em',
					'margin-bottom'   => '0.75em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '1.118em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.474em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0.35px',
					'margin-top'      => '2.4em',
					'margin-bottom'   => '1.1em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '1.5em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '18px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '22px',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'integro' ) ),
					'font-family'     => 'Roboto,sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'integro' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '13px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'integro' ) ),
					'font-family'     => '"Bebas Neue",cursive',
					'font-size'       => '18px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'integro' ) ),
					'font-family'     => 'Roboto,sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'integro' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'integro' ) ),
					'font-family'     => 'Roboto,sans-serif',
				),
			)
		);

		// Font presets
		integro_storage_set(
			'font_presets', array(
				'karla' => array(
								'title'  => esc_html__( 'Karla', 'integro' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Dancing Script',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
													// Google font
													array(
														'name'   => 'Sansita Swashed',
														'family' => 'fantasy',
														'link'   => '',
														'styles' => '300,400,700',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Dancing Script",fantasy',
														'font-size'       => '1.25rem',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
														'font-size'       => '4em',
													),
													'h2'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h3'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h4'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h5'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'h6'      => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'logo'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'button'  => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
													'submenu' => array(
														'font-family'     => '"Sansita Swashed",fantasy',
													),
												),
							),
				'roboto' => array(
								'title'  => esc_html__( 'Roboto', 'integro' ),
								'load_fonts' => array(
													// Google font
													array(
														'name'   => 'Noto Sans JP',
														'family' => 'serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
													// Google font
													array(
														'name'   => 'Merriweather',
														'family' => 'sans-serif',
														'link'   => '',
														'styles' => '300,300italic,400,400italic,700,700italic',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Noto Sans JP",serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Merriweather,sans-serif',
													),
												),
							),
				'garamond' => array(
								'title'  => esc_html__( 'Garamond', 'integro' ),
								'load_fonts' => array(
													// Adobe font
													array(
														'name'   => 'Europe',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
													// Adobe font
													array(
														'name'   => 'Sofia Pro',
														'family' => 'sans-serif',
														'link'   => 'https://use.typekit.net/qmj1tmx.css',
														'styles' => '',
													),
												),
								'theme_fonts' => array(
													'p'       => array(
														'font-family'     => '"Sofia Pro",sans-serif',
													),
													'post'    => array(
														'font-family'     => '',
													),
													'h1'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h2'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h3'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h4'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h5'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'h6'      => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'logo'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'button'  => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'input'   => array(
														'font-family'     => 'inherit',
													),
													'info'    => array(
														'font-family'     => 'inherit',
													),
													'menu'    => array(
														'font-family'     => 'Europe,sans-serif',
													),
													'submenu' => array(
														'font-family'     => 'Europe,sans-serif',
													),
												),
							),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'integro_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'integro_skin_setup_schemes', 1 );
	function integro_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		integro_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'integro' ),
					'description' => esc_html__( 'Colors of the main content area', 'integro' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'integro' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'integro' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'integro' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'integro' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'integro' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'integro' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'integro' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'integro' ),
				),
			)
		);

		integro_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'integro' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'integro' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'integro' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'integro' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'integro' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'integro' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'integro' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'integro' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'integro' ),
					'description' => esc_html__( 'Color of the text inside this block', 'integro' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'integro' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'integro' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'integro' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'integro' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'integro' ),
					'description' => esc_html__( 'Color of the links inside this block', 'integro' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'integro' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'integro' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'integro' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'integro' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'integro' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'integro' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'integro' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'integro' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'integro' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'integro' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F1F1F1', // ok
					'bd_color'         => '#D1D1D1', // ok
					// Text and links colors
					'text'             => '#797C7F', // ok
					'text_light'       => '#AFAFAF', // ok
					'text_dark'        => '#232021', // ok
					'text_link'        => '#97B100', // ok
					'text_hover'       => '#ACC903', // ok
					'text_link2'       => '#DE60CA', // ok
					'text_hover2'      => '#C22BAA', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok 

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff', // ok
					'alter_bg_hover'   => '#ECECEC', // ok
					'alter_bd_color'   => '#D1D1D1', // ok
					'alter_bd_hover'   => '#E1E1E1', // ok
					'alter_text'       => '#797C7F', // ok
					'alter_light'      => '#AFAFAF', // ok
					'alter_dark'       => '#232021', // ok
					'alter_link'       => '#97B100', // ok
					'alter_hover'      => '#ACC903', // ok
					'alter_link2'      => '#DE60CA', // ok
					'alter_hover2'     => '#C22BAA', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#97B100', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#DE60CA', // ok
					'extra_hover2'     => '#C22BAA', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D1D1D1', // ok
					'input_bd_hover'   => '#232021', // ok
					'input_text'       => '#797C7F', // ok
					'input_light'      => '#797C7F', // ok
					'input_dark'       => '#232021', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#232021', 
					'inverse_link'     => '#ffffff', 
					'inverse_hover'    => '#ffffff', 
				),
			),

			// Color scheme: 'default-seo'
			'default-seo' => array(
				'title'    => esc_html__( 'Default SEO', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F9F2F9', // ok
					'bd_color'         => '#FCD8F0', // ok
					// Text and links colors
					'text'             => '#797C7F', // ok
					'text_light'       => '#AFAFAF', // ok
					'text_dark'        => '#232021', // ok
					'text_link'        => '#F8A1DF', // ok
					'text_hover'       => '#F284D2', // ok
					'text_link2'       => '#A1A7F8', // ok
					'text_hover2'      => '#959CF9', // ok
					'text_link3'       => '#FFEBA8', // ok
					'text_hover3'      => '#F6E093', // ok 

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff', // ok
					'alter_bg_hover'   => '#ECECEC', // ok
					'alter_bd_color'   => '#FCD8F0', // ok
					'alter_bd_hover'   => '#F8C7E7', // ok
					'alter_text'       => '#797C7F', // ok
					'alter_light'      => '#AFAFAF', // ok
					'alter_dark'       => '#232021', // ok
					'alter_link'       => '#F8A1DF', // ok
					'alter_hover'      => '#F284D2', // ok
					'alter_link2'      => '#A1A7F8', // ok
					'alter_hover2'     => '#959CF9', // ok
					'alter_link3'      => '#FFEBA8', // ok
					'alter_hover3'     => '#F6E093', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#F8A1DF', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#A1A7F8', // ok
					'extra_hover2'     => '#959CF9', // ok
					'extra_link3'      => '#FFEBA8', // ok
					'extra_hover3'     => '#F6E093', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#FCD8F0', // ok
					'input_bd_hover'   => '#232021', // ok
					'input_text'       => '#797C7F', // ok
					'input_light'      => '#797C7F', // ok
					'input_dark'       => '#232021', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#232021', 
					'inverse_link'     => '#ffffff', 
					'inverse_hover'    => '#ffffff', 
				),
			),


			// Color scheme: 'default-solutions'
			'default-solutions' => array(
				'title'    => esc_html__( 'Default Solutions', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFF8ED', // ok
					'bd_color'         => '#D9CEC7', // ok
					// Text and links colors
					'text'             => '#797C7F', // ok
					'text_light'       => '#AFAFAF', // ok
					'text_dark'        => '#232021', // ok
					'text_link'        => '#FB6E67', // ok
					'text_hover'       => '#EE4A42', // ok
					'text_link2'       => '#9AC1CB', // ok
					'text_hover2'      => '#83B5C2', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok 

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F4E5DB', // ok
					'alter_bg_hover'   => '#F8E1D2', // ok
					'alter_bd_color'   => '#D9CEC7', // ok
					'alter_bd_hover'   => '#CFC1B8', // ok
					'alter_text'       => '#797C7F', // ok
					'alter_light'      => '#AFAFAF', // ok
					'alter_dark'       => '#232021', // ok
					'alter_link'       => '#FB6E67', // ok
					'alter_hover'      => '#EE4A42', // ok
					'alter_link2'      => '#9AC1CB', // ok
					'alter_hover2'     => '#83B5C2', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#FB6E67', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#9AC1CB', // ok
					'extra_hover2'     => '#83B5C2', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#D9CEC7', // ok
					'input_bd_hover'   => '#232021', // ok
					'input_text'       => '#797C7F', // ok
					'input_light'      => '#797C7F', // ok
					'input_dark'       => '#232021', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#67bcc1',
					'inverse_bd_hover' => '#5aa4a9',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#232021', 
					'inverse_link'     => '#ffffff', 
					'inverse_hover'    => '#ffffff', 
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#151414', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#97B100', // ok
					'text_hover'       => '#ACC903', // ok
					'text_link2'       => '#DE60CA', // ok
					'text_hover2'      => '#C22BAA', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#242222', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#97B100', // ok
					'alter_hover'      => '#ACC903', // ok
					'alter_link2'      => '#DE60CA', // ok
					'alter_hover2'     => '#C22BAA', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#97B100', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#DE60CA', // ok
					'extra_hover2'     => '#C22BAA', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#FFFFFF', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#FFFFFF', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#FFFFFF', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#231F1F', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#231F1F', // ok
				),
			),



			// Color scheme: 'agency-dark'
			'agency-dark'    => array(
				'title'    => esc_html__( 'Agency Dark', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#151414', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#E7CFB1', // ok
					'text_link'        => '#6FA4B2', // ok
					'text_hover'       => '#5F909D', // ok
					'text_link2'       => '#E5813E', // ok
					'text_hover2'      => '#D26923', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#242222', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#E7CFB1', // ok
					'alter_link'       => '#6FA4B2', // ok
					'alter_hover'      => '#5F909D', // ok
					'alter_link2'      => '#E5813E', // ok
					'alter_hover2'     => '#D26923', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#E7CFB1', // ok
					'extra_link'       => '#6FA4B2', // ok
					'extra_hover'      => '#E7CFB1', // ok
					'extra_link2'      => '#E5813E', // ok
					'extra_hover2'     => '#D26923', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#E7CFB1', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#E7CFB1', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#E7CFB1', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#231F1F', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#231F1F', // ok
				),
			),

			// Color scheme: 'agency-dark-alter'
			'agency-dark-alter'    => array(
				'title'    => esc_html__( 'Agency Dark Alter', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#242222', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#E7CFB1', // ok
					'text_link'        => '#6FA4B2', // ok
					'text_hover'       => '#5F909D', // ok
					'text_link2'       => '#E5813E', // ok
					'text_hover2'      => '#D26923', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#151414', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#E7CFB1', // ok
					'alter_link'       => '#6FA4B2', // ok
					'alter_hover'      => '#5F909D', // ok
					'alter_link2'      => '#E5813E', // ok
					'alter_hover2'     => '#D26923', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#E7CFB1', // ok
					'extra_link'       => '#6FA4B2', // ok
					'extra_hover'      => '#E7CFB1', // ok
					'extra_link2'      => '#E5813E', // ok
					'extra_hover2'     => '#D26923', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#E7CFB1', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#E7CFB1', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#E7CFB1', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#231F1F', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#231F1F', // ok
				),
			),


			// Color scheme: 'agency-dark'
			'agency-dark'    => array(
				'title'    => esc_html__( 'Agency Dark', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#151414', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#E7CFB1', // ok
					'text_link'        => '#6FA4B2', // ok
					'text_hover'       => '#5F909D', // ok
					'text_link2'       => '#E5813E', // ok
					'text_hover2'      => '#D26923', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#242222', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#E7CFB1', // ok
					'alter_link'       => '#6FA4B2', // ok
					'alter_hover'      => '#5F909D', // ok
					'alter_link2'      => '#E5813E', // ok
					'alter_hover2'     => '#D26923', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#E7CFB1', // ok
					'extra_link'       => '#6FA4B2', // ok
					'extra_hover'      => '#E7CFB1', // ok
					'extra_link2'      => '#E5813E', // ok
					'extra_hover2'     => '#D26923', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#E7CFB1', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#E7CFB1', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#E7CFB1', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#231F1F', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#231F1F', // ok
				),
			),



			// Color scheme: 'startup-dark'
			'startup-dark'    => array(
				'title'    => esc_html__( 'Startup Dark', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#030308', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#E156E6', // ok
					'text_hover'       => '#D532DB', // ok
					'text_link2'       => '#0054D6', // ok
					'text_hover2'      => '#D26923', // ok
					'text_link3'       => '#9752E5', // ok
					'text_hover3'      => '#8336D9', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#0F0F1C', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#E156E6', // ok
					'alter_hover'      => '#D532DB', // ok
					'alter_link2'      => '#0054D6', // ok
					'alter_hover2'     => '#D26923', // ok
					'alter_link3'      => '#9752E5', // ok
					'alter_hover3'     => '#8336D9', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#141524', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#E156E6', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#0054D6', // ok
					'extra_hover2'     => '#D26923', // ok
					'extra_link3'      => '#9752E5', // ok
					'extra_hover3'     => '#8336D9', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#FFFFFF', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#FFFFFF', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#FFFFFF', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#141524', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#141524', // ok
				),
			),

			// Color scheme: 'startup-dark-alter'
			'startup-dark-alter'    => array(
				'title'    => esc_html__( 'Startup Dark Alter', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#0F0F1C', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#E156E6', // ok
					'text_hover'       => '#D532DB', // ok
					'text_link2'       => '#0054D6', // ok
					'text_hover2'      => '#D26923', // ok
					'text_link3'       => '#9752E5', // ok
					'text_hover3'      => '#8336D9', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#030308', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#E156E6', // ok
					'alter_hover'      => '#D532DB', // ok
					'alter_link2'      => '#0054D6', // ok
					'alter_hover2'     => '#D26923', // ok
					'alter_link3'      => '#9752E5', // ok
					'alter_hover3'     => '#8336D9', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#141524', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#E156E6', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#0054D6', // ok
					'extra_hover2'     => '#D26923', // ok
					'extra_link3'      => '#9752E5', // ok
					'extra_hover3'     => '#8336D9', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#FFFFFF', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#FFFFFF', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#FFFFFF', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#141524', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#141524', // ok
				),
			),



			// Color scheme: 'marketing-dark'
			'marketing-dark'    => array(
				'title'    => esc_html__( 'Marketing Dark', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#151414', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#97B100', // ok
					'text_hover'       => '#ACC903', // ok
					'text_link2'       => '#DE60CA', // ok
					'text_hover2'      => '#C22BAA', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#242222', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#97B100', // ok
					'alter_hover'      => '#ACC903', // ok
					'alter_link2'      => '#DE60CA', // ok
					'alter_hover2'     => '#C22BAA', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#97B100', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#DE60CA', // ok
					'extra_hover2'     => '#C22BAA', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#FFFFFF', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#FFFFFF', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#FFFFFF', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#231F1F', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#231F1F', // ok
				),
			),

			// Color scheme: 'marketing-dark-alter'
			'marketing-dark-alter'    => array(
				'title'    => esc_html__( 'Marketing Dark Alter', 'integro' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#242222', // ok
					'bd_color'         => '#3E3E3E', // ok

					// Text and links colors
					'text'             => '#CCCCCC', // ok
					'text_light'       => '#A2A2A2', // ok
					'text_dark'        => '#FFFFFF', // ok
					'text_link'        => '#97B100', // ok
					'text_hover'       => '#ACC903', // ok
					'text_link2'       => '#DE60CA', // ok
					'text_hover2'      => '#C22BAA', // ok
					'text_link3'       => '#9476EC', // ok
					'text_hover3'      => '#704CDB', // ok

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#151414', // ok
					'alter_bg_hover'   => '#2E2D2D', // ok
					'alter_bd_color'   => '#3E3E3E', // ok
					'alter_bd_hover'   => '#5B5B5A', // ok
					'alter_text'       => '#CCCCCC', // ok
					'alter_light'      => '#A2A2A2', // ok
					'alter_dark'       => '#FFFFFF', // ok
					'alter_link'       => '#97B100', // ok
					'alter_hover'      => '#ACC903', // ok
					'alter_link2'      => '#DE60CA', // ok
					'alter_hover2'     => '#C22BAA', // ok
					'alter_link3'      => '#9476EC', // ok
					'alter_hover3'     => '#704CDB', // ok

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#231F1F', // ok
					'extra_bg_hover'   => '#2E2D2D', // ok
					'extra_bd_color'   => '#3E3E3E', // ok
					'extra_bd_hover'   => '#5B5B5A', // ok
					'extra_text'       => '#CCCCCC', // ok
					'extra_light'      => '#A2A2A2', // ok
					'extra_dark'       => '#FFFFFF', // ok
					'extra_link'       => '#97B100', // ok
					'extra_hover'      => '#FFFFFF', // ok
					'extra_link2'      => '#DE60CA', // ok
					'extra_hover2'     => '#C22BAA', // ok
					'extra_link3'      => '#9476EC', // ok
					'extra_hover3'     => '#704CDB', // ok

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent', 
					'input_bg_hover'   => '#transparent', 
					'input_bd_color'   => '#3E3E3E', // ok
					'input_bd_hover'   => '#FFFFFF', // ok
					'input_text'       => '#CCCCCC', // ok
					'input_light'      => '#CCCCCC', // ok
					'input_dark'       => '#FFFFFF', // ok

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#A2A2A2',
					'inverse_bd_hover' => '#CCCCCC',
					'inverse_text'     => '#FFFFFF', // ok
					'inverse_light'    => '#CCCCCC',
					'inverse_dark'     => '#231F1F', // ok
					'inverse_link'     => '#FFFFFF', // ok
					'inverse_hover'    => '#231F1F', // ok
				),
			),

		);
		integro_storage_set( 'schemes', $schemes );
		integro_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> integro_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'integro' ),
		//---> 	'description' => __( 'Description of the new color 1', 'integro' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		integro_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
                'alter_dark_015'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.15,
                ),
                'alter_dark_02'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.2,
                ),
                'alter_dark_05'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.5,
                ),
                'alter_dark_08'     => array(
                    'color' => 'alter_dark',
                    'alpha' => 0.8,
                ),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
                'text_dark_003'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.03,
                ),
                'text_dark_005'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.05,
                ),
                'text_dark_008'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.08,
                ),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
                'text_dark_03'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.3,
                ),
                'text_dark_05'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.5,
                ),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
                'text_dark_08'      => array(
                    'color' => 'text_dark',
                    'alpha' => 0.8,
                ),
                'text_link_007'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.07,
                ),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
                'text_link_03'      => array(
                    'color' => 'text_link',
                    'alpha' => 0.3,
                ),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_05'      => array(
					'color' => 'text_link',
					'alpha' => 0.5,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.8,
                ),
                'text_link2_007'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.07,
                ),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
                'text_link2_03'      => array(
                    'color' => 'text_link2',
                    'alpha' => 0.3,
                ),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
                'text_link3_007'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.07,
                ),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
                'text_link3_03'      => array(
                    'color' => 'text_link3',
                    'alpha' => 0.3,
                ),
                'inverse_text_03'      => array(
                    'color' => 'inverse_text',
                    'alpha' => 0.3,
                ),
                'inverse_link_08'      => array(
                    'color' => 'inverse_link',
                    'alpha' => 0.8,
                ),
                'inverse_hover_08'      => array(
                    'color' => 'inverse_hover',
                    'alpha' => 0.8,
                ),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		integro_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		integro_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		integro_storage_set(
			'color_presets', array(
				'autumn' => array(
								'title'  => esc_html__( 'Autumn', 'integro' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	),
												'dark' => array(
																	'text_link'  => '#d83938',
																	'text_hover' => '#f2b232',
																	)
												)
							),
				'green' => array(
								'title'  => esc_html__( 'Natural Green', 'integro' ),
								'colors' => array(
												'default' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	),
												'dark' => array(
																	'text_link'  => '#75ac78',
																	'text_hover' => '#378e6d',
																	)
												)
							),
			)
		);
	}
}



// Theme init priorities:
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'integro_clone_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'integro_clone_skin_theme_setup3', 3 );
	function integro_clone_skin_theme_setup3() {
		integro_storage_set_array_after( 'options', 'remove_margins', array(
			'extra_bg_image' => array(
				"title" => esc_html__('Extra background image', 'integro'),
				"desc" => wp_kses_data( __('Select or upload background-image to display it in the page. Does not work for boxed body style.', 'integro') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'integro')
				),
				'dependency' => array(
					'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
				),
				"std" => '',
				'pro_only'   => INTEGRO_THEME_FREE,
				"type" => "image"
			),
			'extra_bg_image_size' => array(
				"title" => esc_html__('Extra background image size', 'integro'),
				"desc" => wp_kses_data( __('Use size contain (cover original).', 'integro') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'integro')
				),
				'dependency' => array(
					'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
				),
				"std" => 0,
				'pro_only'   => INTEGRO_THEME_FREE,
				"type" => "switch"
			),
			'extra_bg_image_fixed' => array(
				'title' => esc_html__('Extra background attachment', 'integro'),
				'desc' => wp_kses_data( __('Enable fixed position of the background image', 'integro') ),
				'std' => 0,
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'integro')
				),
				'dependency' => array(
					'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
				),
				'pro_only'   => INTEGRO_THEME_FREE,
				'type' => 'switch'
			),
			)
		);		
	}
}

if ( ! function_exists( 'integro_skin_filter_page_wrap_class' ) ) {
    add_action('integro_filter_page_wrap_class', 'integro_skin_filter_page_wrap_class');
    function integro_skin_filter_page_wrap_class($class) {
        $extra_bg_image = integro_get_theme_option('extra_bg_image');
        $extra_bg_image_size = integro_is_on(integro_get_theme_option('extra_bg_image_size'));
        $extra_bg_image_fixed = integro_is_on(integro_get_theme_option('extra_bg_image_fixed'));
        $body_boxed_style = integro_get_theme_option( 'body_style' ) == 'boxed';
        if (!empty( $extra_bg_image ) && !$body_boxed_style && !$extra_bg_image_fixed) {
            $custom_bg = ' ' . 'with_bg' .($extra_bg_image_size ? ' contain_size ' : ''). ' ' . integro_add_inline_css_class('background-image: url(' . esc_url($extra_bg_image) . ');');
            $class = $class . $custom_bg;
        } else if (!empty( $extra_bg_image ) && !$body_boxed_style && $extra_bg_image_fixed) {
			$class = $class . ' with_bg_fixed';
		}
        return $class;
    }
}

if ( ! function_exists( 'integro_skin_custom_bg_layout' ) ) {
    add_action('integro_action_page_wrap_start', 'integro_skin_custom_bg_layout');
    function integro_skin_custom_bg_layout() {
		$extra_bg_image = integro_get_theme_option('extra_bg_image');
        $extra_bg_image_size = integro_is_on(integro_get_theme_option('extra_bg_image_size'));
        $extra_bg_image_fixed = integro_is_on(integro_get_theme_option('extra_bg_image_fixed'));
        $body_boxed_style = integro_get_theme_option( 'body_style' ) == 'boxed';
		if (!empty( $extra_bg_image ) && !$body_boxed_style && $extra_bg_image_fixed) {
            $custom_bg = ($extra_bg_image_size ? ' contain_size ' : ''). ' ' . integro_add_inline_css_class('background-image: url(' . esc_url($extra_bg_image) . ');');
			?>
				<div class="custom_bg_fixed <?php echo esc_attr($custom_bg); ?>"></div>
			<?php
		}
    }
}

// Enqueue clone specific style
if ( ! function_exists( 'integro_clone_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'integro_clone_frontend_scripts', 1150 );
	function integro_clone_frontend_scripts() {
		$integro_url = integro_get_file_url( integro_skins_get_current_skin_dir() . 'extra-style.css' );
		if ( '' != $integro_url ) {
			wp_enqueue_style( 'integro-extra-skin-' . esc_attr( integro_skins_get_current_skin_name() ), $integro_url, array(), null );
		}
	}
}

// Change thumb size for Accent team
if ( ! function_exists( 'integro_trx_addons_thumb_size_team' ) ) {
	add_filter( 'trx_addons_filter_args_featured', 'integro_trx_addons_thumb_size_team', 10, 2 );
	function integro_trx_addons_thumb_size_team( $args=array(), $type = '' ) {
		if ($type == 'team-accent') {
			$args['thumb_size'] = integro_get_thumb_size('masonry-big');
		}
		return $args;
	}
}

// Activation methods
if ( ! function_exists( 'integro_skin_filter_activation_methods2' ) ) {
    add_filter( 'trx_addons_filter_activation_methods', 'integro_skin_filter_activation_methods2', 11, 1 );
    function integro_skin_filter_activation_methods2( $args ) {
        $args['elements_key'] = true;
        return $args;
    }
}